# $Revision$, $Date$
#
# spec is based on PLD's poldek.spec available at <http://cvs.pld.org.pl/SPECS/>
#
# To build with configuration for particular distro define %{distro}:
# $ rpmbuild -bb ... --define 'distro {pld,fedora,rh}' [--define snap SNAP]
#
#%define _with_poldekuser 1
%define _unpackaged_files_terminate_build  %{nil}
##define snap @SNAP@

Summary:	A full-featured frontend to RPM
Name:		poldek
Version:	0.44.0
Release:	%{?snap:0.%{snap}.}1%{?_with_static:.static}
License:	GPLv2
Group:	        Applications/System
Source0:	http://team.pld.org.pl/~mis/poldek/download/%{name}-%{version}%{?snap:-cvs%{snap}}.tar.bz2
URL:	        http://team.pld.org.pl/~mis/poldek/
Requires:	rpm
%{?_with_poldekuser:Requires: sudo}
BuildRequires:	bzip2-devel
BuildRequires:	rpm-devel >= 4.0
BuildRequires:	openssl-devel
BuildRequires:	readline-devel
BuildRequires:	zlib-devel
BuildRequires:	zstd-devel
BuildRequires:	pcre-devel
%{!?_without_xml_metadata:BuildRequires: libxml2-devel}
%{?_with_static:BuildRequires:	bzip2-static}
%{?_with_static:BuildRequires:	openssl-static}
%{?_with_static:BuildRequires:	rpm-static}
%{?_with_static:BuildRequires:	zlib-static}
%{?_with_static:BuildRequires:	zstd-static}
BuildRoot:	/tmp/%{name}-%{version}-root-%(id -u -n)

%description
poldek is an RPM package management tool which allows you to easily
perform package verification, installation (including system
installation from scratch), upgrading, and removal.

Program can be used in batch (like apt-get from Debian's
APT) or interactive mode. The interactive mode puts you into a
readline interface with command line autocompletion and history,
similar to the shell mode of Perl's CPAN.

%{?_with_static:This version is statically linked}

%package devel
Summary:	poldek headers and documentation
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description devel
poldek's libraries headers and documentation

%package static
Summary:	poldek static libraries
Group:		Development/Libraries
Requires:	%{name}-devel = %{version}-%{release}

%description static
poldek static libraries

%prep
%setup -q -n %{name}-%{version}%{?snap:-cvs%{snap}}

%build
%configure %{?_with_static:--enable-static} %{?_without_xml_metadata:--without-xml-metadata}
%{__make}

%install
rm -rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT%{_sysconfdir}

%{__make} install DESTDIR=$RPM_BUILD_ROOT
%{?_with_static:rm -f $RPM_BUILD_ROOT%{_bindir}/rpmvercmp}

DISTRO=%{?distro:%{distro}}%{!?distro:pld}

CONFIG="$RPM_BUILD_ROOT%{_sysconfdir}/%{name}/%{name}.conf"
# set 'distro' macro
perl -pi -e "s|^_distro\s*=\s*\w+\s*|_distro = $DISTRO\n|" $CONFIG
%{?_with_poldekuser:perl -pi -e "s|^\#?\s*runas\s*=\s*\w+\s*|runas = poldek\n|" $CONFIG}
%{?_with_poldekuser:mkdir -p $RPM_BUILD_ROOT%{_var}/cache/%{name}}

# set PLD architecture
perl -pi -e 's|_pld_arch\s*=\s*i686|_pld_arch = %{_target_cpu}|' $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/pld-*.conf

gzip -9nf README* conf/*sample* NEWS

%clean
rm -rf $RPM_BUILD_ROOT

%pre
%{?_with_poldekuser: PATH="/bin:/sbin:/usr/bin:/usr/sbin"; if [ -z "$(id -u poldek 2>/dev/null)" ]; then groupadd -r -f poldek || exit 1; useradd -r -d %{_var}/cache/poldek -g poldek -s /bin/sh -c "poldek user" poldek || exit 1; fi;}

%post
%{?_with_poldekuser: sh %{_libdir}/%{name}/poldekuser-setup.sh --yes}

/sbin/ldconfig

%postun
if [ "$1" = "0" ]; then
   %{?_with_poldekuser: /usr/sbin/userdel poldek}
   %{?_with_poldekuser: /usr/sbin/groupdel poldek}
fi
/sbin/ldconfig

%files
%defattr(644,root,root,755)
%dir %{_sysconfdir}/%{name}
%attr(644,root,root) %config(noreplace) %verify(not md5 size mtime) %{_sysconfdir}/%{name}/*.conf
%attr(755,root,root) %{_bindir}/*
%ifos freebsd
%attr(755,root,root) %{_libdir}/lib*.so.*
%else # linux
%attr(755,root,root) %{_libdir}/lib*.so.*.*
%endif
%dir %{_libdir}/%{name}
%attr(755,root,root) %{_libdir}/%{name}/*
%{_infodir}/%{name}*
%{_mandir}/man1/%{name}*
%dir %attr(755,poldek,poldek) %{_var}/cache/%{name}
%doc *.gz conf/*.gz doc/manual.css doc/manual.html

%files devel
%defattr(644,root,root,755)
%attr(755,root,root) %{_libdir}/*.so
%{_libdir}/lib*.la
%{_includedir}/%{name}
%{_includedir}/tndb
%{_includedir}/trurl
%{_includedir}/vfile

%files static
%defattr(644,root,root,755)
%{_libdir}/lib*.a


%define date    %(echo `LC_ALL="C" date +"%a %b %d %Y"`)
%changelog
* %{date} poldek
All persons listed below can be reached at <cvs_login>@pld.org.pl

$Log$
Revision 1.33  2005/10/26 22:50:13  mis
- xml metadata bcond

Revision 1.32  2005/05/27 15:27:20  mis
- commented out %%define is still defined? rpm bug?

Revision 1.31  2005/05/23 20:00:49  mis
- updates

Revision 1.30  2005/05/22 13:46:58  mis
- FreeBSD issues

Revision 1.29  2004/10/18 19:58:51  mis
- removed 'cvs' from snapshot package release

Revision 1.28  2004/10/17 20:41:12  mis
- fixes

Revision 1.27  2004/10/17 20:10:44  mis
- reamed userpoldekadd.sh; fixed spec

Revision 1.26  2004/10/17 19:55:44  mis
- fixes

Revision 1.25  2004/10/17 19:02:24  mis
- --with poldekuser param to spec

Revision 1.24  2004/10/09 15:36:52  mis
- finished snap-rpm-package

Revision 1.23  2004/10/09 14:48:29  mis
- make snap-rpm-package

Revision 1.22  2004/09/26 19:37:42  mis
- a big cleanup: renamed non-unique symbols, prepared symbols list to export (*.sym), fixed headers, spec

Revision 1.21  2004/09/23 20:28:08  mis
- updated to 0.2x series (devel and static subpackage, etc)

Revision 1.20  2002/11/07 17:41:07  mis
- used tar.bz2 source

Revision 1.19  2002/06/03 15:45:25  mis
- fixes source URL

Revision 1.18  2002/04/21 16:15:14  mis
- fixed %%doc list

Revision 1.17  2002/04/21 15:38:03  mis
- fixed %%{distro} handling

Revision 1.16  2002/04/14 23:39:09  mis
- fixed %doc list

Revision 1.15  2002/04/10 17:02:31  mis
- easier playing with configs

Revision 1.14  2002/04/06 13:57:27  mis
- added HTTP client; curl module not compiled by default

Revision 1.13  2002/04/04 21:27:31  mis
- +URL

Revision 1.12  2002/03/28 23:37:36  mis
- commented out popt-static build requirement (no such RH package)

Revision 1.11  2002/03/26 00:22:04  mis
- dist config is not PLD one; cosmetics

Revision 1.10  2002/03/18 16:46:25  mis
- added missing changelog name(?)

Revision 1.9  2002/03/09 22:00:57  mis
- updates && slimed down poldekrc.sample-pld

Revision 1.8  2002/02/25 23:59:30  mis
- merged with SPECS's spec

Revision 1.36  2002/01/31 09:41:06  mis
- added 'static' bcond

Revision 1.35  2002/01/30 18:29:45  mis
- autoupdated to 0.16

Revision 1.34  2002/01/18 02:14:38  kloczek
perl -pi -e "s/pld-list\@pld.org.pl/feedback\@pld.org.pl/"

Revision 1.33  2002/01/11 16:43:51  mis
- autoupdated to 0.15.9

Revision 1.32  2001/10/29 11:13:45  mis
- autoupdated to 0.15.8

Revision 1.31  2001/10/11 15:10:27  mis
- fixed source URL; release 2 (may be STB)

Revision 1.30  2001/10/10 14:41:10  mis
- updated to 0.15.7; STB

Revision 1.29  2001/09/20 10:10:14  mis
- STB

Revision 1.28  2001/09/13 10:06:23  filon
- rebuild with optimized zlib-static, release 2

Revision 1.27  2001/09/12 16:33:33  mis
- trurlib 0.43.3 is needed

Revision 1.26  2001/09/12 16:28:04  mis
- updated to 0.15.6
- added global config

Revision 1.25  2001/08/28 12:06:58  filon
- chagded BuildReq: pod2man to perl-devel

Revision 1.24  2001/08/22 17:30:39  filon
- changed BuilReq:/usr/bin/pod2man to pod2man

Revision 1.23  2001/07/20 16:42:27  mis
- updated to 0.15.5

Revision 1.22  2001/07/17 16:12:09  mis
- updated to 0.15.4

Revision 1.21  2001/07/16 20:32:30  kloczek
- reorder BuildRequires rules.

Revision 1.20  2001/07/16 18:38:31  kloczek
- added rpm-static to BuildRequires if %%{BOOT}.

Revision 1.19  2001/07/16 15:19:03  mis
- updated to 0.15.3

Revision 1.18  2001/07/13 15:18:20  mis
- updated to 0.15.2

Revision 1.17  2001/06/28 14:28:13  mis
- updated to 0.15.1

Revision 1.16  2001/06/27 19:20:27  klakier
- removed rpmvercmp from -BOOT
- added debug options to -BOOT (do not work, though))

Revision 1.15  2001/06/27 18:32:55  klakier
- removed -m386

Revision 1.14  2001/06/27 18:09:22  mis
- updated to 0.15

Revision 1.13  2001/06/18 11:31:31  mis
- updated to 0.14.1

Revision 1.12  2001/06/12 18:14:19  mis
- updated to 0.14

Revision 1.11  2001/05/22 23:29:59  klakier
- added -m386 to BOOT

Revision 1.10  2001/05/21 13:27:54  klakier
- more buildrequires

Revision 1.9  2001/05/18 22:28:24  serek
- popt-static added to buildrequires.

Revision 1.8  2001/05/18 18:58:16  mis
- autoupdated to 0.13

Revision 1.7  2001/05/18 12:31:56  roman
- added polish Summary and %description.

Revision 1.6  2001/05/11 14:06:55  klakier
- fixed BuildRequires

Revision 1.5  2001/04/27 20:09:10  kloczek
- finam cleanups.

Revision 1.4  2001/04/27 14:24:43  wiget
fix buildrequires

Revision 1.3  2001/04/27 14:08:11  klakier
- removed rpmvercmp from BOOT

Revision 1.2  2001/04/23 11:43:26  klakier
- ver 0.12
- added BOOT package

Revision 1.1  2000/09/25 00:00:09  mis
- initial version
